import java.net.*;
import java.io.*;

public class ChatClientThread extends Thread
{
  protected Socket socket;
  protected BufferedReader socketIn;
  protected ChatClient chatClient;
  public boolean stopped = false;
  public ChatClientThread(ChatClient chatClient, Socket socket, 
                          BufferedReader socketIn)
  {
    this.socket = socket;
    this.socketIn = socketIn;
    this.chatClient = chatClient;
  }
  public void run()
  {
    String line = null;
    while(!stopped){
      try{
        line = socketIn.readLine();
      }
      catch(IOException e){
        break;
      }
      if (line == null){
        break;
      }
      processMessage(line);
    }
    chatClient.clientThreadStopped();
  }
  public void processMessage(String line)
  {
    chatClient.insertText(line + "\n");
  }
  public void interrupt()
  {
    super.interrupt();
    try{
      socket.close();
    }
    catch(IOException e){}
  }
}
